function F = func_integrates(r,f,J,nstart,nend)
% Integrates f from center to r by a Runge-Kutta resolution of F'=f
% and spline interpolation in Runge-Kutta. More precise than matlab
% elementary functions as cumtrapz.
% Needs : 
%   - r : radii at which integrates
%   - f : vector to integrate
%   - J : number of layers (f is discontinuous = change of layer)
%   - nstart(j), nend(j) : indice of begining and end of layer j
%   - a function func_f.m that returns the f value to ode45
% Gives F = integral_0^r f(y) dy at every point of the vector r.

options=odeset('RelTol',1e-12,'AbsTol',1e-16); 
                    % Sets relative and absolute tolerance for ode solver
                    % May need to be changed.
global ppf % Spline coefficients given to the function func_f.m
n = length(r) ;
y0=0;F=[];

% Integration of the system. That must be done layer by layer because :
% 1. radii at discontinuities appear twice,
% 2. possible extrapolation with ode45 must use values f in the same layer.
% Vectors rspan and fspan are restrictions in the layer of r and f.
for j=1:J
    rspan=r(nstart(j):nend(j));
    fspan=f(nstart(j):nend(j));
    ppf=interp1(rspan,fspan,'spline','pp');
    [T,y]=ode45(@func_f,rspan,y0,options);
    if length(rspan)==2 % If two points, ode45 returns intermediate points
        y=[y(1);y(length(y))];
    end
    F=[F;y];          % Solution in layer is appended to the whole solution
    y0=y(length(y),:);% Starting vector in next layer (F is continuous)
end